
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class Instructor : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.Instructor>
    {
        #region Static factory
        private static Instructor _factory = null;

        public static Instructor DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Instructor();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_InstructorView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Title", "Title"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Forename", "Forename"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Surename", "Surename"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Tel", "Tel"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Email", "Email"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("UserID", "UserID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("SchoolID", "SchoolID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("SchoolName", "SchoolName"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Instructor>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Instructor.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("UserID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("SchoolID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("Forename", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
                Add(new Gemini.Core.BL.DBD.Param("Surename", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
                Add(new Gemini.Core.BL.DBD.Param("Email", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_InstructorView_RestoreBySearch";
            }
        }
        #endregion
    }
}